/**
 * Project Name:qiho-center-api File Name:ItemDetailDto.java Package Name:com.qiho.center.api.dto
 * Date:2017年5月18日下午2:31:45 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import com.qiho.center.api.dto.merchant.MerchantDto;

import java.util.Date;
import java.util.List;

/**
 * ClassName:ItemDetailDto <br/>
 * 商品详情DTO. <br/>
 * Date: 2017年5月18日 下午2:31:45 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class ItemDetailDto extends ItemDto {

    /**
     */
    private static final long    serialVersionUID = 1438637485333096972L;

    /** 商品详情 */
    private String               detail;

    /** 商品创建人ID */
    private Long                 gmtCreator;

    /**
     * 商家ID
     */
    private MerchantDto merchantDto;

    /** 最后修改时间 */
    private Date                 gmtModified;

    /** 商品修改人ID */
    private Long                 gmtModifier;

    /** 商品属性名称列表 */
    private List<SkuPropertyDto> skuPropertyList;

    /** sku列表 */
    private List<ItemSkuDto>     skuList;

    /**
     * detail.
     *
     * @return the detail
     */
    public String getDetail() {
        return detail;
    }

    /**
     * detail.
     *
     * @param detail the detail to set
     */
    public void setDetail(String detail) {
        this.detail = detail;
    }

    /**
     * gmtCreator.
     *
     * @return the gmtCreator
     */
    public Long getGmtCreator() {
        return gmtCreator;
    }

    /**
     * gmtCreator.
     *
     * @param gmtCreator the gmtCreator to set
     */
    public void setGmtCreator(Long gmtCreator) {
        this.gmtCreator = gmtCreator;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * gmtModifier.
     *
     * @return the gmtModifier
     */
    public Long getGmtModifier() {
        return gmtModifier;
    }

    /**
     * gmtModifier.
     *
     * @param gmtModifier the gmtModifier to set
     */
    public void setGmtModifier(Long gmtModifier) {
        this.gmtModifier = gmtModifier;
    }

    /**
     * skuPropertyList.
     *
     * @return the skuPropertyList
     */
    public List<SkuPropertyDto> getSkuPropertyList() {
        return skuPropertyList;
    }

    /**
     * skuPropertyList.
     *
     * @param skuPropertyList the skuPropertyList to set
     */
    public void setSkuPropertyList(List<SkuPropertyDto> skuPropertyList) {
        this.skuPropertyList = skuPropertyList;
    }

    /**
     * skuList.
     *
     * @return the skuList
     */
    public List<ItemSkuDto> getSkuList() {
        return skuList;
    }

    /**
     * skuList.
     *
     * @param skuList the skuList to set
     */
    public void setSkuList(List<ItemSkuDto> skuList) {
        this.skuList = skuList;
    }

    public MerchantDto getMerchantDto() {
        return merchantDto;
    }

    public void setMerchantDto(MerchantDto merchantDto) {
        this.merchantDto = merchantDto;
    }
}
