/**
 * Project Name:qiho-center-api
 * File Name:LogisticsOrderStatusEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年6月6日下午12:45:50
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:LogisticsOrderStatusEnum <br/>
 * 物流订单状态枚举. <br/>
 * Date:     2017年6月6日 下午12:45:50 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum LogisticsOrderStatusEnum {

	/**
     * 接单
     */
    ACCEPT("ACCEPT","接单"),

    /** 在途 */
    UNDER_WAY("UNDER_WAY", "在途"),

	/**
	 * 派件
     */
    SENT_SCAN("SENT_SCAN","派件"),

    /** 签收成功 */
    SUCCESS("SUCCESS", "签收成功"),

    /** 签收失败 */
    FAILED("FAILED", "签收失败"),
    
    /** 退件成功 */
    RETURN("RETURN", "退件成功"),

    /** 拒签 */
    REJECTED("REJECTED", "拒签");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private LogisticsOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static LogisticsOrderStatusEnum getByCode(String code) {
        for (LogisticsOrderStatusEnum enumVal : LogisticsOrderStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

