package com.qiho.center.api.enums.ShotOrder;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/6/22.
 * 策略命中后对应的handler处理器的枚举控制类
 */
public enum ShotOrderHandlerEnum {

    STAMP(1,"stamp","标记",StrategyType.SHOT_ORDER),
    AUDIT_REJECT(2,"auditReject","审核不通过",StrategyType.SHOT_ORDER),
    ONLINE_PAY(3,"onlinePay","在线支付",StrategyType.AHEAD_PREVENT_ORDER),
    NOTE_GAIN(4,"noteGain","短信捞单",StrategyType.SHOT_ORDER);

    int code;
    String val;
    String msg;
    StrategyType[] strategyTypes;

    /**
     * 通过val值去获取对应的枚举
     * @param val
     */
    public static ShotOrderHandlerEnum fromVal(String val){
        if(StringUtils.isBlank(val)){
            return null;
        }
        for (ShotOrderHandlerEnum shotOrderHandlerEnum : ShotOrderHandlerEnum.values()) {
            if (shotOrderHandlerEnum.getVal().equals(val)) {
                return shotOrderHandlerEnum;
            }
        }
        return null;
    }


    ShotOrderHandlerEnum(int code, String val, String msg,StrategyType... strategyType) {
        this.code = code;
        this.val = val;
        this.msg = msg;
        this.strategyTypes = strategyType;
    }

    public int getCode() {
        return code;
    }

    public String getVal() {
        return val;
    }

    public String getMsg() {
        return msg;
    }

    public StrategyType[] getStrategyTypes() {
        return strategyTypes;
    }

}
