package com.qiho.center.api.enums.ShotOrder;

import com.qiho.center.api.dto.resultbase.ResultBase;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;

/**
 * Created by danke on 2017/6/21.
 * 定义校验规则及对应的校验方法
 */
public enum ShotOrderRuleEnum implements ShotOrderValute {


    LESS_THAN(0,"小于","lesser"){
        /**
         * threshold为阈值,hopeVal为期望值属性值,当threshold > hopeVal时,返回ture,命中则返回ture
         * @param threshold
         * @param hopeVal
         * @return
         */
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) > Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }

    },
    LESS_EQUALS(1,"小于等于","lesserEquals"){
        /**
         * threshold为阈值,hopeVal为期望值属性值,当a > b时,返回ture,命中则返回ture
         * @param threshold
         * @param hopeVal
         * @return
         */
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) >= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }

    },
    GREATER_EQUALS(2,"大于等于","greaterEquals"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) <= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    },
    GREATER_THAN(3,"大于","greater"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) < Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    },

    EQUALS_THAN(4,"等于","equals"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            return ResultBase.rightReturn(threshold.equals(String.valueOf(hopeVal)));
        }
    },

    CONTAINS_THAN(5,"包含","contains"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal)
                return ResultBase.rightReturn(Boolean.FALSE);
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e ->StringUtils.contains(hopeValStr,e)).count();
            return ResultBase.rightReturn(filterCount > 0);
        }
    },

    EMPTY_THAN(6,"为空","hollow"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(hopeVal == null ? Boolean.TRUE : StringUtils.isBlank(String.valueOf(hopeVal)));
        }
    },

    NOT_EQUALS_THAN(6,"不等于","notequals"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            return ResultBase.rightReturn(!threshold.equals(String.valueOf(hopeVal)));
        }
    },
    NOT_EMPTY_THAN(7,"不为空","nothollow"){
		@Override
		public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal){
			return ResultBase.rightReturn(hopeVal == null ? Boolean.FALSE: StringUtils.isNotBlank(String.valueOf(hopeVal)));
		}
    },
    //包含中文逗号和英文逗号两种
    CONTAINS_COMMA(8,"包含逗号","containsComma"){
		@Override
		public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
			if (null == hopeVal){
				 return ResultBase.rightReturn(Boolean.FALSE);
			}
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = new String[]{",","，"};
            Long filterCount = Arrays.stream(thresholdStr).filter(e ->StringUtils.contains(hopeValStr,e)).count();
            return ResultBase.rightReturn(filterCount > 0);
		}
    },

    NOT_CONTAINS_THAN(9,"不包含","notcontains"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal)
                return ResultBase.rightReturn(Boolean.FALSE);
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e ->StringUtils.contains(hopeValStr,e)).count();
            return ResultBase.rightReturn(filterCount.intValue() == 0 );
        }
    };





    int code;//状态码
    String msg;//前端页面显示信息
    String val;//规则修饰,落库

    /**
     * @param code
     * @return
     */
    public static ShotOrderRuleEnum fromStatus(Integer code) {
        if (code==null) {
            return null;
        }
        for (ShotOrderRuleEnum shotOrderRuleEnum : ShotOrderRuleEnum.values()) {
            if (shotOrderRuleEnum.getCode() == code) {
                return shotOrderRuleEnum;
            }
        }
        return null;
    }

    /**
     * 通过val值去获取对应的枚举
     * @param val
     */
    public static ShotOrderRuleEnum fromVal(String val){
        if(StringUtils.isBlank(val)){
            return null;
        }
        for (ShotOrderRuleEnum shotOrderRuleEnum : ShotOrderRuleEnum.values()) {
            if (shotOrderRuleEnum.getVal().equals(val)) {
                return shotOrderRuleEnum;
            }
        }
        return null;
    }

    ShotOrderRuleEnum(int code, String msg,String val) {
        this.code = code;
        this.msg = msg;
        this.val = val;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getVal() {
        return val;
    }



}
