package com.qiho.center.api.enums.ShotOrder;

/**
 * Created by danke on 2017/6/24.
 */
public enum StrategyType {

    SHOT_ORDER(1, "shot_order", "踢单辅助使用"),
    PHONE_BLACKLIST(2,"phone_blacklist","手机黑名单策略"),
    PLACE_BLACKLIST(3,"place_blacklist","地域黑名单策略"),
    AHEAD_PREVENT_ORDER(4,"ahead_prevent_order","下单规则策略");

    int code;
    String value;
    String message;

    public String getValue() {
        return value;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }


    /**
     * @param code
     * @return
     */
    public static StrategyType fromCode(Integer code) {
        if (code==null) {
            return null;
        }
        for (StrategyType strategyType : StrategyType.values()) {
            if (strategyType.getCode() == code) {
                return strategyType;
            }
        }
        return null;
    }


    StrategyType(int code, String value, String message) {
        this.code = code;
        this.value = value;
        this.message = message;
    }

}
