package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/9/21.
 * 短信渠道类型枚举
 */
public enum  SmsTypeEnum {

    YUNPIAN("YUNPIAN","云片"),
    YUNZHIXUN("YUNZHIXUN","云之讯");

    private String code;
    private String msg;

    SmsTypeEnum(String code,String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 通过val值去获取对应的枚举
     * @param code
     */
    public static SmsTypeEnum fromCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for (SmsTypeEnum smsTypeEnum : SmsTypeEnum.values()) {
            if (smsTypeEnum.getCode().equals(code)) {
                return smsTypeEnum;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
