package com.qiho.center.api.enums.coupon;

import org.apache.commons.lang.StringUtils;

import java.util.EnumMap;

/**
 * Created by danke on 2017/10/31.
 * 限制主体类型
 */
public enum AstrictTypeEnum {


    CHANNEL("CHANNEL","渠道");

    private String val;
    private String msg;
    private EnumMap<AstrictTypeEnum, CouponAstrictEnum[]> payChannelMap = new EnumMap<>(AstrictTypeEnum.class);

    AstrictTypeEnum(String val, String msg) {
        payChannelMap.put(this,CouponAstrictEnum.values());
        this.val = val;
        this.msg = msg;
    }

    public static AstrictTypeEnum getByCode(String val) {
        for (AstrictTypeEnum enumVal : AstrictTypeEnum.values()) {
            if (StringUtils.equals(val, enumVal.getVal())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getVal() {
        return val;
    }

    public String getMsg() {
        return msg;
    }

}
