package com.qiho.center.api.enums.coupon;

import org.apache.commons.lang.StringUtils;

/** 查询优惠券时间类型枚举
 * @author chensong
 * @create 2017-11-02 19:57
 **/
public enum QueryCouponTimeTypeEnum {

    CREATE_TIME("CREATE_TIME","发券时间"),

    EXPIRE_TIME("EXPIRE_TIME","到期时间"),

    USED_TIME("USED_TIME","使用时间");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    QueryCouponTimeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static QueryCouponTimeTypeEnum getByCode(String code) {
        for (QueryCouponTimeTypeEnum enumVal : QueryCouponTimeTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }



}
