package com.qiho.center.api.enums.finance;

import org.apache.commons.lang3.StringUtils;

/**
 * @author chensong
 * @create 2017-12-19 19:23
 **/
public enum FinanceDetailStatusEnum {

    PROCESSING("PROCESSING", "处理中", 1),

    FAILED("FAILED", "失败", 8),

    ERROR("ERROR", "异常", 9),

    SUCCESS("SUCCESS", "完成", 10);

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    /**
     * 数值
     */
    private Integer num;

    FinanceDetailStatusEnum(String code, String desc, Integer num) {
        this.code = code;
        this.desc = desc;
        this.num = num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getNum() {
        return num;
    }

    public static FinanceDetailStatusEnum getByCode(String code) {
        for (FinanceDetailStatusEnum value : FinanceDetailStatusEnum.values()) {
            if (StringUtils.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    public static FinanceDetailStatusEnum getByNum(int num) {
        for (FinanceDetailStatusEnum value : FinanceDetailStatusEnum.values()) {
            if (value.getNum().intValue() == num) {
                return value;
            }
        }
        return null;
    }

    public static FinanceDetailStatusEnum getByNum(Integer num) {
        return getByNum(num.intValue());
    }
}
