/**
 * Project Name:qiho-center-api
 * File Name:RemoteItemPropertyService.java
 * Package Name:com.qiho.center.api.remoteservice
 * Date:2017年5月22日下午10:00:26
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.SkuPropertyValueDto;

/**
 * ClassName:RemoteItemPropertyService <br/>
 * Date:     2017年5月22日 下午10:00:26 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteItemPropertyService {

    /**
     * 批量保存属性名
     * @author zhanglihui
     * @param propertyNames
     * @return 返回id：属性名Map
     */
    DubboResult<Map<Long, String>> createPropertyNames(List<String> propertyNames);
    
    
    /**
     * 批量保存属性值
     * @author zhanglihui
     * @param propertyValues 属性值列表
     * @return id：属性值Map
     */
    DubboResult<Map<Long, String>> createPropertyValues(List<SkuPropertyValueDto> propertyValues);
    
    /**
     * 根据ID更新属性值
     *
     * @author zhanglihui
     * @param id
     * @param propertyValue
     * @return DubboResult
     */
    DubboResult<Void> updatePropertyValue(Long id, String propertyValue);
}

