/**
 * Project Name:qiho-center-api
 * File Name:RemoteItemService.java
 * Package Name:com.qiho.center.api.remoteservice
 * Date:2017年5月18日上午9:37:17
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.*;
import com.qiho.center.api.enums.ItemStatusEnum;
import com.qiho.center.api.params.item.ItemPageParams;

/**
 * ClassName:RemoteItemService <br/>
 * 类目管理dubbo服务 <br/>
 * Date:     2017年5月18日 上午9:37:17 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteItemService {
    /**
     * 分页查询商品列表
     * @author zhanglihui
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return PagenationDto<ItemDto>
     */
    DubboResult<PagenationDto<ItemDto>> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize);
    
    /**
     * 新建一个商品
     *
     * @author zhanglihui
     * @param itemDetail
     * @return 商品ID
     */
    DubboResult<Long> createItem(ItemDetailDto itemDetail);
    
    
    /**
     * 更新商品信息
     * @author zhanglihui
     * @param itemDetail
     * @return DubboResult
     */
    DubboResult<Void> updateItem(ItemDetailDto itemDetail);
    
    /**
     * 根据商品ID查询商品详情
     * @author zhanglihui
     * @param itemId
     * @return ItemDetailDto
     */
    DubboResult<ItemDetailDto> queryItemDetail(Long itemId);
    
    /**
     * 批量下架商品
     *
     * @author zhanglihui
     * @param itemIds 商品ID列表
     * @param status  更新后的商品状态，{@link ItemStatusEnum}
     * @return DubboResult
     */
    DubboResult<Void> updateStatus(List<Long> itemIds, String status);
    
    
    /**
     * 批量删除商品
     * @author zhanglihui
     * @param itemIds 商品ID列表
     * @return DubboResult
     */
    DubboResult<Void> deleteBatch(List<Long> itemIds);
    
    /**
     * 查询商品基本信息
     * @author zhanglihui
     * @param itemId 商品ID
     * @return ItemSimpleDto
     */
    DubboResult<ItemSimpleDto> queryItemSimpleDto(Long itemId);

	/**
     * 不分页查询所有商品基本信息
     * @return
     */
    DubboResult<List<ItemSimpleDto>> queryItemSimpleList(ItemDto queryItem);

    /**
     * 根据itemId,更新extParam扩展信息
     */
    DubboResult<Boolean> updateExtParamByItemId(ItemAdvertDto dto);

    /**
     * 根据itemId查询商品扩展信息
     */
    DubboResult<ItemAdvertDto> queryExtParamByItemId(Long itemId);

    /**
     * 根据商品id查询商品总库存
     */
    Long queryItemStockByItemId(Long itemId);

    /**
     * 更具商品id更新虚拟库存
     */
    Long updateVirtailStock(Long itemId);

    /**
     * 分页查询商品列表，用于外部商家
     * @param params
     * @return
     */
    PagenationDto<ItemDto> queryMerchantItemPage(ItemPageParams params);

}

