package com.qiho.center.api.remoteservice.area;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.area.AddressDto;

import java.util.List;

/** 用户地址服务远程接口
 * @author chensong
 * @create 2018-01-26 11:49
 **/
@AdvancedFeignClient
public interface RemoteAddressService {

    /**
     * 根据地id获取
     * @param addressId
     * @return
     */
    AddressDto findById(Long addressId);

    /**
     * 新增收货地址
     * @param dto
     * @return
     */
    Boolean createAddress(AddressDto dto);

    /**
     * 根据用户id获取收货地址列表 如果有默认地址则放在第一条
     * @param userId
     * @return
     */
    List<AddressDto> findByUserId(Long userId);

    /**
     * 删除收货地址 逻辑删除
     * @param dto
     * @return
     */
    Boolean deleteAddress(AddressDto dto);

    /**
     * 用户修改默认地址
     * @param dto
     * @return
     */
    Boolean alterDefault(AddressDto dto);

    /**
     * 更新地址
     * @param dto
     * @return
     */
    Boolean updateAddress(AddressDto dto);



}
