package com.qiho.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.CouponConsumerDto;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.api.params.CouponConsumerQueryParams;

import java.util.List;

/**
 * Created by danke on 2017/11/1.
 */
@AdvancedFeignClient
public interface RemoteCouponConsumerService {

    Integer insert(CouponConsumerDto dto);

    /**
     * 通过手机号查询改用户所有优惠券
     * @param mobile
     * @return
     */
    List<CouponConsumerDto> findAllCouponByMobile(String mobile);

    /**
     * 通过校验参数查询用户可用的优惠券
     * @param params
     * @return
     */
    List<CouponConsumerDto> findCouponUseAble(AstrictCouponParams params);

    /**
     * 分页查询已发优惠券
     * @param params
     * @return
     */
    PagenationDto<CouponConsumerDto> findCouponConsumerByQuery(CouponConsumerQueryParams params);

    /**
     * 用户优惠券领取接口
     * @param params
     * @return
     */
    List<CouponConsumerDto> consumerGetCoupon(AstrictCouponParams params);

    /**
     * 校验用户是否满足参与活动规则
     */
    Boolean verfiyConsumer(AstrictCouponParams params);

    List<CouponConsumerDto> findByOrderId(String orderId);

}
