package com.qiho.center.api.remoteservice.finance;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.AllocateAmountDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.enums.finance.PartnerResultStateEnum;
import com.qiho.center.api.params.PageQueryParams;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 商户资金远程服务接口
 *
 * @author chensong
 * @create 2017-12-19 18:48
 **/
@AdvancedFeignClient
public interface RemoteFinanceService {

    /**
     * 查询所有财务基础实体类
     *
     * @return
     */
    PagenationDto<FinanceDto> findAll(PageQueryParams pageParam);

    /**
     * 金额分配(划拨)
     *
     * @param allocateAmountDto
     * @return
     */
    PartnerResultStateEnum allocateAmountRecharge(AllocateAmountDto allocateAmountDto) throws BizException;

    /**
     * 金额分配(回拨)
     *
     * @param allocateAmountDto
     * @return
     */
    PartnerResultStateEnum allocateAmountReverse(AllocateAmountDto allocateAmountDto) throws BizException;

    /**
     * 查询商家
     * 账户信息
     */
    FinanceDto findFinanceByMerchantId(long merchantId);

    /**
     * 根据关联查询
     *
     * @param typeEnum   关联类型
     * @param relationId 关联id
     * @return
     */
    FinanceDto findByRelation(FinanceTypeEnum typeEnum, Long relationId);

}
