package com.qiho.center.api.remoteservice.merchant;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.api.params.MerchantQueryParams;

import java.util.List;

/**
 * 商家服务远程接口
 *
 * @author chensong
 * @create 2017-11-15 10:56
 **/
@AdvancedFeignClient
public interface RemoteMerchantService {

    /**
     * 根据id 获取商家信息
     *
     * @param merchantId
     * @return
     */
    MerchantDto findById(Long merchantId);

    /**
     * 创建或更新商家
     *
     * @param dto
     * @return
     */
    Boolean saveMerchant(MerchantDto dto);

    /**
     * 分页查询商家信息
     *
     * @param params
     * @return
     */
    PagenationDto<MerchantDto> querypage(MerchantQueryParams params);

    /**
     * 根据商家名称半模糊匹配
     *
     * @param name
     * @return
     */
    List<MerchantDto> findListByName(String name);

    /**
     * 根据商品Id返回商家信息
     *
     * @param itemId
     * @return
     */
    MerchantDto findByItemId(Long itemId);

    /**
     * 查询所有商家id和名称
     *
     * @return
     */
    List<SimpleIdAndNameDto> findAllMerchantSimple();

    /**
     * 查询所有排除已经关联过的商家庄户的商家的id和名称
     *
     * @return
     */
    List<SimpleIdAndNameDto> findAllIdAndNames();

    /**
     * 获取所有商家简单数据信息
     *
     * @return 集合
     */
    List<MerchantSpacialDto> findAll();

    /**
     * 根据商家和类型查询广告主ID
     *
     * @param merchantId   商家ID
     * @param relationType 类型值
     * @param merchantId
     * @return
     */
    Long findRelationIdByMerchantIdAndRelationType(Long merchantId, BaiqiMerchantLinkTypeEnum relationType);

    /**
     * 查询商家不配送地区
     *
     * @param merchantId  商家id
     * @return            商家不配送等行政区域代码集
     */
    List<String> findUndelivery(Long merchantId);
}
