/**
 * Project Name:qiho-center-api
 * File Name:RemoteErpOrderService.java
 * Package Name:com.qiho.center.api.remoteservice.order
 * Date:2017年6月6日上午11:33:12
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.api.params.WdtOrderAuditParams;

import java.util.List;

/**
 * ClassName:RemoteErpOrderService <br/>
 * ERP子订单服务. <br/>
 * Date:     2017年6月6日 上午11:33:12 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteErpOrderService {

    /**
     * 根据订单ID查询ERP订单列表
     * @author zhanglihui
     * @param orderId
     * @return List<ErpOrderDto>
     */
    DubboResult<List<ErpOrderDto>> findByOrderId(String orderId);

    /**
     * 查询ERP子订单的分页
     * @param params
     * @return
     */
    DubboResult<List<OrderSnapshotDto>> findWdtExportErpOrder(ErpOrderPageParams params);

    /**
     * 查询ERP子订单的总数
     * @param params
     * @return
     */
    DubboResult<Integer> findErpOrderPageCount(ErpOrderPageParams params);

    /**
     * 查询ERP子订单的分页
     * @param params
     * @return
     */
    DubboResult<PagenationDto<ErpOrderDto>> findErpOrderPage(ErpOrderPageParams params);

    /**
     * 取消发货
     * @param erpId
     * @return
     */
    DubboResult<Boolean> cancelDeliver(String erpId);

    /**
     * 确认发货
     * @param params
     * @return
     */
    DubboResult<Boolean> resolveDeliver(ResolveDeliverParams params);

    /**
     * 批量处理
     * @param progressKey
     * @param paramList
     * @return
     */
    DubboResult<Integer> batchResolveErpDeliver(String progressKey,List<BatchResolveErpDeliverParams> paramList);
    
    /**
     * 批量审核失败处理
     * @param progressKey
     * @param list
     * @return
     */
    DubboResult<Integer> batchReviewFaildErpOrder(String progressKey,List<ErpOrderDto> list);
    
    /**
     * 更新ERP订单状态
     *
     * @param erpId
     * @param erpStatus
     * @return DubboResult
     */
    DubboResult<Void> updateStatus(String erpId, String erpStatus);
    
    /**
     * 更新ERP订单ID
     * @param id 
     * @param erpId 
     *
     * @return DubboResult
     */
    DubboResult<Void> updateErpId(Long id, String erpId);

    /**
     * 旺店通订单审核
     */
    DubboResult<Integer> wdtBatchAuditOrder(String cacheKey,List<WdtOrderAuditParams> list);
}

