package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.OrderStrategyParams;

/**
 * Created by danke on 2017/6/21.
 * 踢单策略的暴露接口
 */
@AdvancedFeignClient
public interface RemoteOrderStrategyService {

    /**
     * 分页查询
     */
    DubboResult<PagenationDto<OrderStrategyDto>> queryStrategyByPage(OrderStrategyParams params, Integer pageNum, Integer pageSize);

    /**
     * 通过id删除
     */
    DubboResult<Boolean> deleteStrategyById(Long id);

    /**
     * 更新
     */
    DubboResult<Boolean> updateStrategyByParam(OrderStrategyDto orderStrategyDto);

    /**
     * 插入
     */
    DubboResult<Integer> insertStrategy(OrderStrategyDto orderStrategyDto);

    /**
     * 条件查询总记录数
     */
    DubboResult<Integer> countByParam(OrderStrategyParams params);
}
