package com.qiho.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.user.WechatUserDto;

/**
 * 微信用户前台服务
 *
 * @author peanut.huang
 * @date 2018/1/26.
 */
@AdvancedFeignClient
public interface RemoteWechatUserService {

    /**
     * 添加微信用户
     *
     * @param wechatUserDto 微信用户dto
     * @return
     */
    Boolean insertUser(WechatUserDto wechatUserDto);

    /**
     * 根据小程序openId获取百奇用户id
     *
     * @param miniOpenId 小程序openId
     * @return           百奇用户id
     */
    Long findUserIdByMiniOpenId(String miniOpenId);
}
