package com.qiho.center.api.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by danke on 2017/10/19.
 * 简单的json工具,用于处理扩展字段
 */
public class JSONUtil {
    private JSONUtil(){}

    public static <T> List<T> parseJSONStrToList(String key, String metaValue, Class<T> clazz){
        Assert.notNull(clazz,"转换类型不能为空");
        if (StringUtils.isBlank(key) || StringUtils.isBlank(metaValue))
            return new ArrayList<>();
        JSONObject extJson = JSONObject.parseObject(metaValue);
        String stageStr =  extJson.getString(key);
        if(StringUtils.isNotBlank(stageStr)){
            return JSONObject.parseArray(stageStr,clazz);
        }
        return new ArrayList<>();
    }

    /**
     * 可能返回null
     * @param key
     * @param metaValue
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T parseJSONStrToObject(String key, String metaValue, Class<T> clazz) {
        Assert.notNull(clazz,"转换类型不能为空");
        if (StringUtils.isBlank(key) || StringUtils.isBlank(metaValue))
            return null;
        JSONObject extJson = JSONObject.parseObject(metaValue);
        String stageStr =  extJson.getString(key);
        if(StringUtils.isNotBlank(stageStr)){
            return JSONObject.parseObject(stageStr,clazz);
        }
        return null;
    }


}
