/**
 * Project Name:qiho-center-api File Name:OrderDto.java Package Name:com.qiho.center.api.dto Date:2017年6月2日下午6:24:29
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import com.qiho.center.api.enums.OrderStatusEnum;

import java.util.Date;

/**
 * ClassName:OrderDto <br/>
 * 订单信息 Date: 2017年6月2日 下午6:24:29 <br/>
 *
 * @author zhanglihui
 * @see
 * @since JDK 1.6
 */
public class OrderDto extends BaseDto {

    /**
     */
    private static final long serialVersionUID = -9019491095252749491L;

    /**
     * 订单编号
     */
    private String orderId;

    /**
     * 订单状态，{@link OrderStatusEnum}
     */
    private String orderStatus;

    /**
     * 皮肤ID
     */
    private Long skinId;

    /**
     * 下单url
     */
    private String url;

    /**
     * 买家ID，前期没有会员系统时填手机号码
     */
    private String consumerId;

    /**
     * 买家姓名
     */
    private String consumerName;

    /**
     * 买家电话
     */
    private String mobile;

    /**
     * 买家留言
     */
    private String message;

    /**
     * 订单金额，单位：分
     */
    private Integer orderAmt;

    /**
     * 行政区划代码
     */
    private String areaNum;

    /**
     * 省/直辖市
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区县
     */
    private String district;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 订单商品详情
     */
    private OrderItemDto orderItem;

    /**
     * tuiaId
     */
    private String tuiaId;

    /**
     * 页面停留时间
     */
    private Long remainTime;

    /**
     * A/Btest测试code
     */
    private String planCode;

    /**
     * 订单原始金额
     */
    private Integer orderOriginalAmt;

    /**
     * 优惠券id
     */
    private Long couponId;

    /**
     * 快递派送时间
     */
    private String sendTime;

    /**
     * 来源参数
     */
    private String sid;

    /**
     * 商品商家id
     */
    private Long              merchantId;

    /**
     * tuiaId.
     *
     * @return the tuiaId
     */
    public String getTuiaId() {
        return tuiaId;
    }

    /**
     * tuiaId.
     *
     * @param tuiaId the tuiaId to set
     */
    public void setTuiaId(String tuiaId) {
        this.tuiaId = tuiaId;
    }

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * orderStatus.
     *
     * @return the orderStatus
     */
    public String getOrderStatus() {
        return orderStatus;
    }

    /**
     * orderStatus.
     *
     * @param orderStatus the orderStatus to set
     */
    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * consumerId.
     *
     * @return the consumerId
     */
    public String getConsumerId() {
        return consumerId;
    }

    /**
     * consumerId.
     *
     * @param consumerId the consumerId to set
     */
    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * consumerName.
     *
     * @return the consumerName
     */
    public String getConsumerName() {
        return consumerName;
    }

    /**
     * consumerName.
     *
     * @param consumerName the consumerName to set
     */
    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    /**
     * mobile.
     *
     * @return the mobile
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * mobile.
     *
     * @param mobile the mobile to set
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    /**
     * message.
     *
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * message.
     *
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * orderAmt.
     *
     * @return the orderAmt
     */
    public Integer getOrderAmt() {
        return orderAmt;
    }

    /**
     * orderAmt.
     *
     * @param orderAmt the orderAmt to set
     */
    public void setOrderAmt(Integer orderAmt) {
        this.orderAmt = orderAmt;
    }

    /**
     * areaNum.
     *
     * @return the areaNum
     */
    public String getAreaNum() {
        return areaNum;
    }

    /**
     * areaNum.
     *
     * @param areaNum the areaNum to set
     */
    public void setAreaNum(String areaNum) {
        this.areaNum = areaNum;
    }

    /**
     * province.
     *
     * @return the province
     */
    public String getProvince() {
        return province;
    }

    /**
     * province.
     *
     * @param province the province to set
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * city.
     *
     * @return the city
     */
    public String getCity() {
        return city;
    }

    /**
     * city.
     *
     * @param city the city to set
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * district.
     *
     * @return the district
     */
    public String getDistrict() {
        return district;
    }

    /**
     * district.
     *
     * @param district the district to set
     */
    public void setDistrict(String district) {
        this.district = district;
    }

    /**
     * address.
     *
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * address.
     *
     * @param address the address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * remark.
     *
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * orderItem.
     *
     * @return the orderItem
     */
    public OrderItemDto getOrderItem() {
        return orderItem;
    }

    /**
     * orderItem.
     *
     * @param orderItem the orderItem to set
     */
    public void setOrderItem(OrderItemDto orderItem) {
        this.orderItem = orderItem;
    }

    public Long getRemainTime() {
        return remainTime;
    }

    public void setRemainTime(Long remainTime) {
        this.remainTime = remainTime;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public Integer getOrderOriginalAmt() {
        return orderOriginalAmt;
    }

    public void setOrderOriginalAmt(Integer orderOriginalAmt) {
        this.orderOriginalAmt = orderOriginalAmt;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public String getSendTime() {
        return sendTime;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public String getSid() {
        return sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
