package com.qiho.center.api.enums.ShotOrder;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/6/21.
 * 定义订单校验维度名称及详细介绍,订单基本属性如果需要复杂校验的,配上key,key用于获取自定义执行action
 */
public enum ShotOrderFieldEnum {

    TUIA_ID(0,"推啊id","tuiaId",""),

    PLACE_ORDER_TIME(1,"页面停留时长(秒)","remainTime",""),

    LEAVE_WORDS(2,"用户留言","message",""),

    CHANNEL_ID(3,"结算7hoId","channelId",""),

    COUNT_CHANNEL_ID(4,"统计7hoId","countChannelId",""),
    
    COUNT_QUANTITY(5,"订单件数","quantity",""),
    
    CONSUMER_NAME(6,"收件人姓名","consumerName",""),
    
    ADDRESS(7,"详细地址","info-address",""),

    SKU_NO(8,"货号","itemNo",""),

    REPEAT_ORDER_PHONE(101,"24小时下单量(手机号统计)","count-mobile",ShotOrderConstant.StrategyAction.REPEAT_PLACE_ORDER),

    REPEAT_ORDER_TUIAID(102,"24小时下单量(推啊id统计)","count-tuiaId",ShotOrderConstant.StrategyAction.REPEAT_PLACE_ORDER),

    ADRESS_LENGTH(103,"详细地址的长度","address",ShotOrderConstant.StrategyAction.ADRESS_LENGTH),


    // add by peanut.huang on 2018.03.15
    REPEAT_ORDER_IP(104,"24小时下单量(ip统计)","count-ip",ShotOrderConstant.StrategyAction.REPEAT_PLACE_ORDER),

    PHONE_STATUS(105,"下单手机号状态","mobile",ShotOrderConstant.StrategyAction.ORDER_MOBILE)


    ;



    //code之后作为判断数据类型的值,提供前段渲染做判断
    private int code;
    private String msg;
    private String val;//订单信息中的字段名
    private String key;//复杂链路的map调用key

    /**
     * @param code
     * @return
     */
    public static ShotOrderFieldEnum fromStatus(Integer code) {
        if (code==null) {
            return null;
        }
        for (ShotOrderFieldEnum shotOrderFieldEnum : ShotOrderFieldEnum.values()) {
            if (shotOrderFieldEnum.getCode() == code) {
                return shotOrderFieldEnum;
            }
        }
        return null;
    }

    /**
     * 通过val值去获取对应的枚举
     * @param val
     */
    public static ShotOrderFieldEnum fromVal(String val){
        if(StringUtils.isBlank(val)){
            return null;
        }
        for (ShotOrderFieldEnum shotOrderFieldEnum : ShotOrderFieldEnum.values()) {
            if (shotOrderFieldEnum.getVal().equals(val)) {
                return shotOrderFieldEnum;
            }
        }
        return null;
    }



    ShotOrderFieldEnum(int code, String msg, String val, String key) {
        this.code = code;
        this.msg = msg;
        this.val = val;
        this.key = key;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getVal() {
        return val;
    }

    public String getKey() {
        return key;
    }
}
