package com.qiho.center.api.enums;

/**
 * 库存预警状态枚举
 * Author：zhanghuifeng
 * Date: Created in 10:19 2018/3/2
 */
public enum StockWarnStatusEnum {
    STOCKOUT(1, "缺货"),
    EARLY_WARNING(0, "预警");

    private int status;

    private String name;

    StockWarnStatusEnum(int status, String name){
        this.status = status;
        this.name = name;
    }

    public static String getName(Integer status){
        if (status == null){
            return null;
        }
        for (StockWarnStatusEnum val : StockWarnStatusEnum.values()){
            if (val.getStatus() == status){
                return val.getName();
            }
        }
        return null;
    }

    public int getStatus() {
        return status;
    }

    public String getName() {
        return name;
    }
}
