package com.qiho.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: LogisticsOrderStatusEnum <br/>
 * Function: 圆通物流订单状态. <br/>
 * date: 2017年6月3日 下午2:26:40 <br/>
 *
 * @author chencheng
 * @version
 */
public enum YTOLogisticsStatusEnum {
    /** 接单 */
    ACCEPT("ACCEPT", "接单"),
    
    /** 不接单 */
    UNACCEPT("UNACCEPT", "不接单"),
    
    /** 已收件 */
    GOT("GOT", "已收件"),
    
    /** 揽收失败 */
    NOT_SEND("NOT_SEND", "揽收失败"),
    
    /** 已收入 */
    ARRIVAL("ARRIVAL", "已收入"),
    
    /** 已发出 */
    DEPARTURE("DEPARTURE", "已发出"),
    
    /** 已打包 */
    PACKAGE("PACKAGE", "已打包"),
    
    /** 已拆包 */
    UNPACK("UNPACK", "已拆包"),
    
    /** 派件 */
    SENT_SCAN("SENT_SCAN", "派件"),
    
    /** 签收成功 */
    SIGNED("SIGNED", "签收成功"),
    
    /** 签收失败 */
    FAILED("FAILED", "签收失败");
     
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private YTOLogisticsStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<String,YTOLogisticsStatusEnum> enumMap = Maps.newHashMap();
    private static Map<String,YTOLogisticsStatusEnum> nameEnumMap = Maps.newHashMap();
    static {
        for(YTOLogisticsStatusEnum it:YTOLogisticsStatusEnum.values()){
            enumMap.put(it.code,it);
            nameEnumMap.put(it.desc, it);
        }
    }
    
    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return YTOLogisticsStatusEnum
     */
    public static YTOLogisticsStatusEnum getByCode(String code) {
        return enumMap.get(code);
    }
    /**
     * 
     * getByName:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param name
     * @return YTOLogisticsStatusEnum
     */
    public static YTOLogisticsStatusEnum getByName(String name) {
        return nameEnumMap.get(name);
    }

    /**
     *
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     *
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

