package com.qiho.center.api.enums.coupon;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/10/31.
 * 优惠券限制类型,每一个对应一个限制模块
 */
public enum CouponAstrictEnum implements AstrictMark {

    ORDER_AMT("ORDER_AMT", "订单金额>=", "元"),

    ITEM_NUM("ITEM_NUM", "购买数量>=", "件");

    private String val;
    private String msg;
    private String unit;

    CouponAstrictEnum(String val, String msg, String unit) {
        this.val = val;
        this.msg = msg;
        this.unit = unit;
    }

    public static CouponAstrictEnum getByCode(String val) {
        for (CouponAstrictEnum enumVal : CouponAstrictEnum.values()) {
            if (StringUtils.equals(val, enumVal.getVal())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getVal() {
        return val;
    }

    public String getMsg() {
        return msg;
    }

    public String getUnit() {
        return unit;
    }

}
