package com.qiho.center.api.enums.coupon;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/11/1.
 * 优惠券状态枚举
 */
public enum  CouponStatusEnum {

    UN_USE("UN_USE","未使用"),

    BE_USE("BE_USE","已使用"),

    OUT_OF_DATE("OUT_OF_DATE","已过期");

    private String val;
    private String msg;

    CouponStatusEnum(String val, String msg) {
        this.val = val;
        this.msg = msg;
    }

    public static CouponStatusEnum getByVal(String val) {
        for (CouponStatusEnum enumVal : CouponStatusEnum.values()) {
            if (StringUtils.equals(val, enumVal.getVal())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getVal() {
        return val;
    }

    public String getMsg() {
        return msg;
    }

}
