package com.qiho.center.api.enums.page;

import java.util.Arrays;

/**
 * @author peanut.huang
 * @date 2018/2/23.
 */
public enum PageTypeEnum {

    /**
     *
     */
    ITEM_DETAIL(1, "商品详情页");

    private int value;

    private String desc;

    PageTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static PageTypeEnum findByValue(int value){
        return Arrays.stream(PageTypeEnum.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
