package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.ConfigParams;

import java.util.List;

/**
 * Created by chensong on 2017/7/17 0017.
 */
@AdvancedFeignClient
public interface RemoteConfigService {

    /**
     * 根据配置名称获取配置值
     * @param name
     * @return 配置值
     */
    DubboResult<String> findByName(String name);

    /**
     * 更新或插入配置项
     * @param param
     * @return 更新时返回受影响行数，插入时返回生成的主键
     */
    DubboResult<Integer> saveConfig(ConfigParams param);


    /**
     * 查找所有的配置项
     * @return
     */
    DubboResult<List<ConfigDto>> findAllConfig();


    /**
     * 根据name更新配置项
     * @param param
     * @return 受影响行数
     */
    DubboResult<Integer> updateByName(ConfigParams param);

    /**
     * 根据支付类型获取配置项的value
     * @param type
     * @return
     */
    DubboResult<String> findValueByPayType(PayTypeEnum type);


}
