package com.qiho.center.api.remoteservice.agent;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.agent.BaiqiAgentSaveDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.params.agent.AgentPageParam;

import java.util.List;

/**
 * Created by sunchangji on 2017/12/15.
 */
@AdvancedFeignClient
public interface RemoteBaiqiAgentBackendService {

    /**
     * 查询所有代理账户id和名称
     * @return
     */
    List<SimpleIdAndNameDto> findAgentSimple();

    /**
     * 排除已经与代理账户关联的
     * @return
     */
    List<SimpleIdAndNameDto> findAgentIdAndName();

    /**
     * 分页查询所有代理商信息
     * @return 代理商
     */
    PagenationDto<BaiqiAgentDto> find4Page(AgentPageParam params);

    /**
     * 保存代理商
     * @param agentSaveDto 数据
     * @return boolean
     */
    Boolean save(BaiqiAgentSaveDto agentSaveDto) throws BizException;

    /**
     * 查询所有排除已经被代理商关联过的商家id和名称
     *
     * @return 集合
     */
    List<MerchantSimpleDto> findAllIdAndNames();

    /**
     * 查询当前代理商已关联商家数据
     * @param agentId 代理商id
     * @return 商家集合
     */
    List<MerchantSimpleDto> findMerchantsByAgentId(Long agentId);

    /**
     * 获取所有简单代理商信息
     * @return 集合
     */
    List<BaiqiAgentDto> findAll();

    /**
     * 根据商家id查询关联的代理商
     * @param merchantId 商家id
     * @return
     */
    BaiqiAgentDto findAgentByMerchantId(String merchantId);
}
