package com.qiho.center.api.remoteservice.homepage;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;

import java.util.List;

/**
 * Created by qianjue on 2017/8/29.
 */
@AdvancedFeignClient
public interface RemoteTabItemService {

	/**
	 * 批量新增tab商品
	 * @param list
	 * @return
	 */
	DubboResult<Integer> saveTabItemList(List<TabItemParams> list);

	/**
	 * 批量删除item
	 * @param idList
	 * @return
	 */
	DubboResult<Integer> deleteTabItemByIdList(List<Long> idList);

	/**
	 * 批量置顶/取消置顶商品
	 * @param idList
	 * @param top
	 * @return
	 */
	DubboResult<Integer> updateTabItemTopPayloadByList(List<Long> idList,Boolean top);

	/**
	 * 查询商品列表
	 * @param params
	 * @return
	 */
	DubboResult<List<TabItemDto>> findTabItemList(TabItemQueryParam params);



	DubboResult<List<ItemDto>> queryTabItemIndex(TabItemQueryParam params);
}
