package com.qiho.center.api.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Zhangshun on 2018/3/21,13:30:02.
 */
public class BizLog {

    private static final Logger LOGGER = LoggerFactory.getLogger("innerLog");

    private BizLog() {
        throw new IllegalStateException("Utility class");
    }

    // =====================
    // info
    // =====================

    public static void log(String msg) {
        LOGGER.info(msg);
    }

    public static void log(String format, Object arg) {
        LOGGER.info(format, arg);
    }

    public static void log(String format, Object arg1, Object arg2) {
        LOGGER.info(format, arg1, arg2);
    }

    public static void log(String format, Object... arguments) {
        LOGGER.info(format, arguments);
    }

    public static void log(String msg, Throwable t) {
        LOGGER.info(msg, t);
    }

}
