/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums.ShotOrder;

import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderValute;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public enum ShotOrderRuleEnum implements ShotOrderValute
{
    LESS_THAN(0, "\u5c0f\u4e8e", "lesser"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) > Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    LESS_EQUALS(1, "\u5c0f\u4e8e\u7b49\u4e8e", "lesserEquals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) >= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    GREATER_EQUALS(2, "\u5927\u4e8e\u7b49\u4e8e", "greaterEquals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) <= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    GREATER_THAN(3, "\u5927\u4e8e", "greater"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) < Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    EQUALS_THAN(4, "\u7b49\u4e8e", "equals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            return ResultBase.rightReturn(threshold.equals(String.valueOf(hopeVal)));
        }
    }
    ,
    CONTAINS_THAN(5, "\u5305\u542b", "contains"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e -> StringUtils.contains((String)hopeValStr, (String)e)).count();
            return ResultBase.rightReturn(filterCount > 0L);
        }
    }
    ,
    EMPTY_THAN(6, "\u4e3a\u7a7a", "hollow"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(hopeVal == null ? Boolean.TRUE : StringUtils.isBlank((String)String.valueOf(hopeVal)));
        }
    }
    ,
    NOT_EQUALS_THAN(6, "\u4e0d\u7b49\u4e8e", "notequals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            return ResultBase.rightReturn(!threshold.equals(String.valueOf(hopeVal)));
        }
    }
    ,
    NOT_EMPTY_THAN(7, "\u4e0d\u4e3a\u7a7a", "nothollow"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(hopeVal == null ? Boolean.FALSE : StringUtils.isNotBlank((String)String.valueOf(hopeVal)));
        }
    }
    ,
    CONTAINS_COMMA(8, "\u5305\u542b\u9017\u53f7", "containsComma"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == hopeVal) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = new String[]{",", "\uff0c"};
            Long filterCount = Arrays.stream(thresholdStr).filter(e -> StringUtils.contains((String)hopeValStr, (String)e)).count();
            return ResultBase.rightReturn(filterCount > 0L);
        }
    }
    ,
    NOT_CONTAINS_THAN(9, "\u4e0d\u5305\u542b", "notcontains"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e -> StringUtils.contains((String)hopeValStr, (String)e)).count();
            return ResultBase.rightReturn(filterCount.intValue() == 0);
        }
    }
    ,
    UN_KNOWS(10, "\u672a\u77e5", "unknowns"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(StringUtils.equals((String)"300002", (String)hopeValStr));
        }
    }
    ,
    EMPTY_NUM(11, "\u7a7a\u53f7", "emptyNum"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(StringUtils.equals((String)"300003", (String)hopeValStr));
        }
    }
    ,
    NOT_CONTAIN_CN(12, "\u4e0d\u5305\u542b\u4e2d\u6587", "notContainCN"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(this.notContainCN(hopeValStr));
        }

        private boolean notContainCN(String str) {
            String regex = "[\\u4e00-\\u9fa5]";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(str);
            return !m.find();
        }
    };

    int code;
    String msg;
    String val;

    public static ShotOrderRuleEnum fromStatus(Integer code) {
        if (code == null) {
            return null;
        }
        for (ShotOrderRuleEnum shotOrderRuleEnum : ShotOrderRuleEnum.values()) {
            if (shotOrderRuleEnum.getCode() != code.intValue()) continue;
            return shotOrderRuleEnum;
        }
        return null;
    }

    public static ShotOrderRuleEnum fromVal(String val) {
        if (StringUtils.isBlank((String)val)) {
            return null;
        }
        for (ShotOrderRuleEnum shotOrderRuleEnum : ShotOrderRuleEnum.values()) {
            if (!shotOrderRuleEnum.getVal().equals(val)) continue;
            return shotOrderRuleEnum;
        }
        return null;
    }

    private ShotOrderRuleEnum(int code, String msg, String val) {
        this.code = code;
        this.msg = msg;
        this.val = val;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getVal() {
        return this.val;
    }
}

