package com.qiho.center.api.enums;

import java.util.stream.Stream;

/**
 * 快递鸟物流状态
 * @author: wangjin
 * @create 2018-06-12 09:23
 **/
public enum ExpressBirdLogisticsStatusEnum {

    /**接单 */
    ACCEPT("1","已揽收"),
    /** 在途 */
    UNDER_WAY("2","在途中"),
    /** 派件 */
    ARRIVE_CITY("201","到达派件城市"),
    SENT_SCAN("202", "派件中"),
    /** 签收成功 */
    SUCCESS("3", "已签收"),
    /** 签收失败 */
    TROUBLE("4","问题件"),
    NO_INFO("401","发货无信息"),
    OVERTIME_SIGN("402","超时未签收"),
    OVERTIME_UPDATE("403","超时未更新"),
    /** 拒签 */
    REJECTED("404","拒收(退件)");

    private String state;

    private String desc;

    ExpressBirdLogisticsStatusEnum(String state,String desc){
        this.state = state;
        this.desc = desc;
    }

    public static ExpressBirdLogisticsStatusEnum getByState(String state){
        return Stream.of(ExpressBirdLogisticsStatusEnum.values())
                .filter(item -> item.getState().equals(state))
                .findFirst().orElse(null);
    }

    public String getState(){
        return state;
    }

    public String getDesc(){
        return desc;
    }

}
