package com.qiho.center.api.enums;

import java.util.stream.Stream;

/**
 * 快递鸟和百奇订单状态映射
 * @author: wangjin
 * @create 2018-06-12 09:19
 **/
public enum ExpressBirdOrderStatusEnum {

    ACCEPT("ACCEPT","1","接单"),
    UNDER_WAY("UNDER_WAY","2","在途"),
    ARRIVE_CITY("SENT_SCAN","201","派件"),
    SENT_SCAN("SENT_SCAN","202", "派件"),
    SUCCESS("SUCCESS","3", "签收成功"),
    TROUBLE("FAILED","4","签收失败"),
    NO_INFO("FAILED","401","签收失败"),
    OVERTIME_SIGN("FAILED","402","签收失败"),
    OVERTIME_UPDATE("FAILED","403","签收失败"),
    REJECTED("REJECTED","404","拒签");

    /** 代码 */
    private String status;

    private String expressBirdStatus;

    /** 描述 */
    private String desc;

    ExpressBirdOrderStatusEnum(String status,String expressBirdStatus,String desc){
        this.status = status;
        this.expressBirdStatus = expressBirdStatus;
        this.desc = desc;
    }

    public static ExpressBirdOrderStatusEnum getByExpressBird(String status){
        return Stream.of(ExpressBirdOrderStatusEnum.values())
                .filter(item -> item.getExpressBirdStatus().equals(status))
                .findFirst()
                .orElse(null);
    }

    public String getStatus(){
        return status;
    }
    public String getExpressBirdStatus(){
        return expressBirdStatus;
    }
    public String getDesc(){
        return desc;
    }
}
