package com.qiho.center.api.enums.coupon;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/11/1.
 * 活动规则枚举
 */
public enum ActiveRuleEnum implements AstrictMark{

    /**
     * 仅新用户参与
     */
    NEW_CONSUMER("NEW_CONSUMER","仅限未下过单的新用户");

    private String val;
    private String msg;

    ActiveRuleEnum(String val, String msg) {
        this.val = val;
        this.msg = msg;
    }

    public static ActiveRuleEnum getByCode(String val) {
        for (ActiveRuleEnum enumVal : ActiveRuleEnum.values()) {
            if (StringUtils.equals(val, enumVal.getVal())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getVal() {
        return val;
    }

    public String getMsg() {
        return msg;
    }
}
