package com.qiho.center.api.enums.coupon;

import org.apache.commons.lang.StringUtils;

/** 优惠券 优惠类型 枚举
 * @author chensong
 * @create 2017-11-03 14:18
 **/
public enum CouponTypeEnum {

    SUB_CASH("SUB_CASH","减现金"),

    DISCOUNT("DISCOUNT","打折");


    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    CouponTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static CouponTypeEnum getByCode(String code) {
        for (CouponTypeEnum enumVal : CouponTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }



}
