package com.qiho.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.CouponDto;
import com.qiho.center.api.dto.coupon.CouponOrderDto;
import com.qiho.center.api.params.CouponQueryParams;

import java.util.List;

/**
 * Created by danke on 2017/10/31.
 * 优惠券服务接口
 */
@AdvancedFeignClient
public interface RemoteCouponService {

    /**
     * 新增优惠券模板
     * @param dto
     * @return
     */
    Boolean insert(CouponDto dto);

    Integer update(CouponOrderDto dto);

    Integer delete(Long couponId);

    CouponDto findByCouponId(Long couponId);

    PagenationDto<CouponDto> findCouponByQuery(CouponQueryParams params);

    /**
     * 优惠券模板批量查询接口
     */
    List<CouponDto> batchFindCouponByIds(List<Long> couponIds);
}
