package com.qiho.center.api.remoteservice.logistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.logistics.LogisticsStatusDto;
import com.qiho.center.api.params.logitics.ExpressBirdReturnParam;

import java.util.List;

/**
 * 快递鸟远程调用接口
 * @author: wangjin
 * @create 2018-06-11 11:04
 **/
@AdvancedFeignClient
public interface RemoteExpressBackendService {


    /**
     * 校验快递鸟签名
     * @param sign
     * @return
     */
    boolean checkExpressSign(String sign,String data);

    /**
     * 处理快递鸟推送过来的状态
     * @return
     */
    ExpressBirdReturnParam dealExpressStatus(List<LogisticsStatusDto> list);


}
