package com.qiho.center.api.dto.consumer;

import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.OrderTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@Accessors(chain = true)
public class ConsumerOrderDto implements Serializable {
    private static final long serialVersionUID = 594266682688439074L;

    /**
     * 订单编号
     */
    private String orderId;

    /**
     * 订单金额，单位：分
     */
    private Integer orderAmt;

    /**
     * 付款方式，COD-货到付款
     */
    private String payType;

    /**
     * 订单类型 {@link OrderTypeEnum}
     */
    private String orderType = OrderTypeEnum.BAIQI.getCode();

    /**
     * 订单状态 {@link OrderStatusEnum}
     */
    private String orderStatus;

    /**
     * 下单时间
     */
    private Long createTime;

    /**
     * 订单是否被访问过
     */
    private Boolean accessFlag;

    /**
     * 商品信息
     */
    private ConsumerItemDto consumerItemDto;

    /**
     * 收货地址信息
     */
    private ConsumerAddressDto consumerAddressDto;

    /**
     * 物流信息
     */
    private ConsumerDeliveryDto consumerDeliveryDto;

    /**
     *  是否已处理
     */
    private Integer isOperate;

    /**
     * 虚拟订单信息
     */
    private VirtualItemDTO virtualItemDTO;
}
