package com.qiho.center.api.dto.order.param;


import com.qiho.center.api.dto.AfterSaleStageDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/21 2:18 下午
 */
@Data
public class AfterSaleOrderParam implements Serializable {


    private static final long serialVersionUID = -6434484130272126979L;
    /**
     * 订单号
     */
    private String orderId;

    /**
     * 交易账号
     */
    private String account;

    /**
     * 退运费金额
     */
    private Integer refreightAmt;

    /**
     * 退款金额,单位：分
     */
    private Integer refundAmt;


    /**
     * 买家姓名
     */
    private String consumerName;

    /**
     * 买家电话
     */
    private String mobile;

    /**
     * 售后子订单原因
     */
    private String afterSaleReason;

    /**
     * 支付类型
     */
    private String payType;

    /**
     * 售后子订单类型 退货退运费/退货不退运费 {@link com.qiho.center.api.enums.AfterSaleOrderTypeEnum}
     */
    private String afterSaleType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 售后子订单ID
     */
    private String afterSaleId;

    /**
     * 操作类型 {@link com.qiho.center.api.enums.order.AfterSaleOperateTypeEnum}
     */
    private Integer operateType;

    /**
     * 物流单号
     */
    private String postId;

    /**
     * 物流公司代码
     */
    private String logisticCode;

    /** 操作详情 */
    private List<AfterSaleStageDto> detailStage;

    /**
     * 退货地址id
     */
    private Long merchantAddressId;

    /**
     * 商家说明
     */
    private String merchantDesc;

    /**
     * 付款截图
     */
    private String payRecordUrl;

    private Long merchantId;

    private String itemName;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 操作类型 {@link com.qiho.center.api.enums.order.OrderOperatorTypeEnum}
     */
    private Integer operatorType;



}
