package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 *
 * Created by chensong on 2017/10/10 0010.
 * 售后子订单类型枚举
 */
public enum AfterSaleOrderTypeEnum {

    RETURN_AND_FREIGHT("RETURN_AND_FREIGHT","退货退运费"),

    RETURN_NOT_FREIGHT("RETURN_NOT_FREIGHT","退货不退运费"),

    ONLY_REFUND("ONLY_REFUND", "仅退款"),

    REFUND_AND_PRODUCT("REFUND_AND_PRODUCT", "退货退款")
    ;

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private AfterSaleOrderTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AfterSaleOrderTypeEnum getByCode(String code) {
        for (AfterSaleOrderTypeEnum enumVal : AfterSaleOrderTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getByMsg(String code) {
        AfterSaleOrderTypeEnum orderTypeEnum = getByCode(code);
        if (orderTypeEnum == null) {
            return "";
        }
        return orderTypeEnum.getDesc();
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }



}
