package com.qiho.center.api.enums;

/**
 * ClassName: TabItemStatusEnum <br/>
 * date: 2018年5月15日 18:51:07 <br/>
 *
 * @author jiafeng.geng
 */
public enum TabItemStatusEnum {
    /**
     * tab下商品启用
     */
    STATUS_ON(1, "启用"),

    /**
     * tab下商品禁用
     */
    STATUS_OFF(0, "禁用");

    /**
     * 代码
     */
    private Integer value;

    /**
     * 描述
     */
    private String desc;

    private TabItemStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * @param value
     * @return DatabaseSchema
     */
    public static TabItemStatusEnum getByValue(Integer value) {
        for (TabItemStatusEnum enumVal : TabItemStatusEnum.values()) {
            if (value == enumVal.getValue()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return value
     */
    public Integer getValue() {
        return value;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

