package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeAHEnum implements AreaCodeEnumerable {
    CODE_340000("340000", "安徽省"),
    CODE_340100("340100", "安徽省合肥市"),
    CODE_340101("340101", "安徽省合肥市市辖区"),
    CODE_340102("340102", "安徽省合肥市东市区"),
    CODE_340103("340103", "安徽省合肥市中市区"),
    CODE_340104("340104", "安徽省合肥市西市区"),
    CODE_340111("340111", "安徽省合肥市郊区"),
    CODE_340121("340121", "安徽省合肥市长丰县"),
    CODE_340122("340122", "安徽省合肥市肥东县"),
    CODE_340123("340123", "安徽省合肥市肥西县"),
    CODE_340200("340200", "安徽省芜湖市"),
    CODE_340201("340201", "安徽省芜湖市市辖区"),
    CODE_340202("340202", "安徽省芜湖市镜湖区"),
    CODE_340203("340203", "安徽省芜湖市马塘区"),
    CODE_340204("340204", "安徽省芜湖市新芜区"),
    CODE_340207("340207", "安徽省芜湖市鸠江区"),
    CODE_340221("340221", "安徽省芜湖市芜湖县"),
    CODE_340222("340222", "安徽省芜湖市繁昌县"),
    CODE_340223("340223", "安徽省芜湖市南陵县"),
    CODE_340300("340300", "安徽省蚌埠市"),
    CODE_340301("340301", "安徽省蚌埠市市辖区"),
    CODE_340302("340302", "安徽省蚌埠市东市区"),
    CODE_340303("340303", "安徽省蚌埠市中市区"),
    CODE_340304("340304", "安徽省蚌埠市西市区"),
    CODE_340311("340311", "安徽省蚌埠市郊区"),
    CODE_340321("340321", "安徽省蚌埠市怀远县"),
    CODE_340322("340322", "安徽省蚌埠市五河县"),
    CODE_340323("340323", "安徽省蚌埠市固镇县"),
    CODE_340400("340400", "安徽省淮南市"),
    CODE_340401("340401", "安徽省淮南市市辖区"),
    CODE_340402("340402", "安徽省淮南市大通区"),
    CODE_340403("340403", "安徽省淮南市田家庵区"),
    CODE_340404("340404", "安徽省淮南市谢家集区"),
    CODE_340405("340405", "安徽省淮南市八公山区"),
    CODE_340406("340406", "安徽省淮南市潘集区"),
    CODE_340421("340421", "安徽省淮南市凤台县"),
    CODE_340500("340500", "安徽省马鞍山市"),
    CODE_340501("340501", "安徽省马鞍山市市辖区"),
    CODE_340502("340502", "安徽省马鞍山市金家庄区"),
    CODE_340503("340503", "安徽省马鞍山市花山区"),
    CODE_340504("340504", "安徽省马鞍山市雨山区"),
    CODE_340505("340505", "安徽省马鞍山市向山区"),
    CODE_340521("340521", "安徽省马鞍山市当涂县"),
    CODE_340600("340600", "安徽省淮北市"),
    CODE_340601("340601", "安徽省淮北市市辖区"),
    CODE_340602("340602", "安徽省淮北市杜集区"),
    CODE_340603("340603", "安徽省淮北市相山区"),
    CODE_340604("340604", "安徽省淮北市烈山区"),
    CODE_340621("340621", "安徽省淮北市濉溪县"),
    CODE_340700("340700", "安徽省铜陵市"),
    CODE_340701("340701", "安徽省铜陵市市辖区"),
    CODE_340702("340702", "安徽省铜陵市铜官山区"),
    CODE_340703("340703", "安徽省铜陵市狮子山区"),
    CODE_340711("340711", "安徽省铜陵市郊区"),
    CODE_340721("340721", "安徽省铜陵市铜陵县"),
    CODE_340800("340800", "安徽省安庆市"),
    CODE_340801("340801", "安徽省安庆市市辖区"),
    CODE_340802("340802", "安徽省安庆市迎江区"),
    CODE_340803("340803", "安徽省安庆市大观区"),
    CODE_340811("340811", "安徽省安庆市郊区"),
    CODE_340822("340822", "安徽省安庆市怀宁县"),
    CODE_340823("340823", "安徽省安庆市枞阳县"),
    CODE_340824("340824", "安徽省安庆市潜山县"),
    CODE_340825("340825", "安徽省安庆市太湖县"),
    CODE_340826("340826", "安徽省安庆市宿松县"),
    CODE_340827("340827", "安徽省安庆市望江县"),
    CODE_340828("340828", "安徽省安庆市岳西县"),
    CODE_340881("340881", "安徽省安庆市桐城市"),
    CODE_341000("341000", "安徽省黄山市"),
    CODE_341001("341001", "安徽省黄山市市辖区"),
    CODE_341002("341002", "安徽省黄山市屯溪区"),
    CODE_341003("341003", "安徽省黄山市黄山区"),
    CODE_341004("341004", "安徽省黄山市徽州区"),
    CODE_341021("341021", "安徽省黄山市歙县"),
    CODE_341022("341022", "安徽省黄山市休宁县"),
    CODE_341023("341023", "安徽省黄山市黟县"),
    CODE_341024("341024", "安徽省黄山市祁门县"),
    CODE_341100("341100", "安徽省滁州市"),
    CODE_341101("341101", "安徽省滁州市市辖区"),
    CODE_341102("341102", "安徽省滁州市琅琊区"),
    CODE_341103("341103", "安徽省滁州市南谯区"),
    CODE_341122("341122", "安徽省滁州市来安县"),
    CODE_341124("341124", "安徽省滁州市全椒县"),
    CODE_341125("341125", "安徽省滁州市定远县"),
    CODE_341126("341126", "安徽省滁州市凤阳县"),
    CODE_341181("341181", "安徽省滁州市天长市"),
    CODE_341182("341182", "安徽省滁州市明光市"),
    CODE_341200("341200", "安徽省阜阳市"),
    CODE_341201("341201", "安徽省阜阳市市辖区"),
    CODE_341202("341202", "安徽省阜阳市颍州区"),
    CODE_341203("341203", "安徽省阜阳市颍东区"),
    CODE_341204("341204", "安徽省阜阳市颍泉区"),
    CODE_341221("341221", "安徽省阜阳市临泉县"),
    CODE_341222("341222", "安徽省阜阳市太和县"),
    CODE_341223("341223", "安徽省阜阳市涡阳县"),
    CODE_341224("341224", "安徽省阜阳市蒙城县"),
    CODE_341225("341225", "安徽省阜阳市阜南县"),
    CODE_341226("341226", "安徽省阜阳市颍上县"),
    CODE_341227("341227", "安徽省阜阳市利辛县"),
    CODE_341281("341281", "安徽省阜阳市亳州市"),
    CODE_341282("341282", "安徽省阜阳市界首市"),
    CODE_341300("341300", "安徽省宿州市"),
    CODE_341301("341301", "安徽省宿州市市辖区"),
    CODE_341302("341302", "安徽省宿州市甬桥区"),
    CODE_341321("341321", "安徽省宿州市砀山县"),
    CODE_341322("341322", "安徽省宿州市萧县"),
    CODE_341323("341323", "安徽省宿州市灵璧县"),
    CODE_341324("341324", "安徽省宿州市泗县"),
    CODE_342400("342400", "安徽省六安地区"),
    CODE_342401("342401", "安徽省六安地区六安市"),
    CODE_342422("342422", "安徽省六安地区寿县"),
    CODE_342423("342423", "安徽省六安地区霍邱县"),
    CODE_342425("342425", "安徽省六安地区舒城县"),
    CODE_342426("342426", "安徽省六安地区金寨县"),
    CODE_342427("342427", "安徽省六安地区霍山县"),
    CODE_342500("342500", "安徽省宣城地区"),
    CODE_342501("342501", "安徽省宣城地区宣州市"),
    CODE_342502("342502", "安徽省宣城地区宁国市"),
    CODE_342522("342522", "安徽省宣城地区郎溪县"),
    CODE_342523("342523", "安徽省宣城地区广德县"),
    CODE_342529("342529", "安徽省宣城地区泾县"),
    CODE_342530("342530", "安徽省宣城地区旌德县"),
    CODE_342531("342531", "安徽省宣城地区绩溪县"),
    CODE_342600("342600", "安徽省巢湖地区"),
    CODE_342601("342601", "安徽省巢湖地区巢湖市"),
    CODE_342622("342622", "安徽省巢湖地区庐江县"),
    CODE_342623("342623", "安徽省巢湖地区无为县"),
    CODE_342625("342625", "安徽省巢湖地区含山县"),
    CODE_342626("342626", "安徽省巢湖地区和县"),
    CODE_342900("342900", "安徽省池州地区"),
    CODE_342901("342901", "安徽省池州地区贵池市"),
    CODE_342921("342921", "安徽省池州地区东至县"),
    CODE_342922("342922", "安徽省池州地区石台县"),
    CODE_342923("342923", "安徽省池州地区青阳县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeAHEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
