package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeHANEnum implements AreaCodeEnumerable {
    CODE_460000("460000", "海南省"),
    CODE_460001("460001", "海南省三亚市通什市"),
    CODE_460002("460002", "海南省三亚市琼海市"),
    CODE_460003("460003", "海南省三亚市儋州市"),
    CODE_460004("460004", "海南省三亚市琼山市"),
    CODE_460005("460005", "海南省三亚市文昌市"),
    CODE_460006("460006", "海南省三亚市万宁市"),
    CODE_460007("460007", "海南省三亚市东方市"),
    CODE_460025("460025", "海南省三亚市定安县"),
    CODE_460026("460026", "海南省三亚市屯昌县"),
    CODE_460027("460027", "海南省三亚市澄迈县"),
    CODE_460028("460028", "海南省三亚市临高县"),
    CODE_460030("460030", "海南省三亚市白沙黎族自治县"),
    CODE_460031("460031", "海南省三亚市昌江黎族自治县"),
    CODE_460033("460033", "海南省三亚市乐东黎族自治县"),
    CODE_460034("460034", "海南省三亚市陵水黎族自治县"),
    CODE_460035("460035", "海南省三亚市保亭黎族苗族自治县"),
    CODE_460036("460036", "海南省三亚市琼中黎族苗族自治县"),
    CODE_460037("460037", "海南省西沙群岛"),
    CODE_460038("460038", "海南省南沙群岛"),
    CODE_460039("460039", "海南省中沙群岛的岛礁及其海域"),
    CODE_460100("460100", "海南省海口市"),
    CODE_460101("460101", "海南省海口市市辖区"),
    CODE_460102("460102", "海南省海口市振东区"),
    CODE_460103("460103", "海南省海口市新华区"),
    CODE_460104("460104", "海南省海口市秀英区"),
    CODE_460200("460200", "海南省三亚市"),
    CODE_460201("460201", "海南省三亚市市辖区"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeHANEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
