package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeTJEnum implements AreaCodeEnumerable {
    CODE_120000("120000", "天津市"),
    CODE_120100("120100", "天津市市辖区"),
    CODE_120101("120101", "天津市和平区"),
    CODE_120102("120102", "天津市河东区"),
    CODE_120103("120103", "天津市河西区"),
    CODE_120104("120104", "天津市南开区"),
    CODE_120105("120105", "天津市河北区"),
    CODE_120106("120106", "天津市红桥区"),
    CODE_120107("120107", "天津市塘沽区"),
    CODE_120108("120108", "天津市汉沽区"),
    CODE_120109("120109", "天津市大港区"),
    CODE_120110("120110", "天津市东丽区"),
    CODE_120111("120111", "天津市西青区"),
    CODE_120112("120112", "天津市津南区"),
    CODE_120113("120113", "天津市北辰区"),
    CODE_120200("120200", "天津市县"),
    CODE_120221("120221", "天津市宁河县"),
    CODE_120222("120222", "天津市武清县"),
    CODE_120223("120223", "天津市静海县"),
    CODE_120224("120224", "天津市宝坻县"),
    CODE_120225("120225", "天津市蓟县");
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeTJEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
