package com.qiho.center.api.enums.flag;

public enum OrderSnapshotFlagEnum {
    FLAG_AFTER_SALE_STATUS("FLAG_AFTER_SALE_STATUS", 1),//订单售后状态
    ;

    /**
     * flag名称
     */
    private String name;

    /**
     * flag位置
     */
    private int pos;

    OrderSnapshotFlagEnum(String name, int pos){
        this.name = name;
        this.pos = pos;
    }

    public int getPos() {
        return pos;
    }

    public String getName() {
        return name;
    }

    public static OrderSnapshotFlagEnum getByName(String flagName) {
        for (OrderSnapshotFlagEnum value : OrderSnapshotFlagEnum.values()) {
            if(value.name.equals(flagName))
                return value;
        }
        return null;
    }
}
