package com.qiho.center.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/21 2:01 下午
 */
@Getter
@AllArgsConstructor
public enum  AfterSaleOperateTypeEnum {

    START(1, "发起售后"),
    REFUND_AND_PRODUCT(2, "发起退货退款"),
    REVERT_REFUND(3, "撤销退款"),
    PAY_AGAIN(4, "重新打款"),
    CONFIRM_REFUND_SUCCESS(5, "确认退款成功"),
    AGREE(6, "同意退货退款申请"),
    CONFIRM_RECEIVE(7, "确认收货"),
    HAVE_MONEY(8, "已打款"),
    REJECT_REFUND(9, "拒绝退款"),
    MODIFY(10, "修改售后");

    private Integer type;

    private String desc;

    public static AfterSaleOperateTypeEnum getByType(Integer type) {
        for (AfterSaleOperateTypeEnum sale : AfterSaleOperateTypeEnum.values()) {
            if (sale.getType().equals(type)) {
                return sale;
            }
        }
        return AfterSaleOperateTypeEnum.START;
    }
}
