package com.qiho.center.api.enums.trading.statistics;

import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description
 * @date 2020/9/1 4:46 下午
 */
public enum CloseStatusEnum {

    WAIT(0,"待结算"),

    CLOSED(1,"结算完成");

    private int code;

    private String desc;

    CloseStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        for (CloseStatusEnum value : CloseStatusEnum.values()) {
            if (code != null && code == value.getCode()) {
                return value.getDesc();
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
