package com.qiho.center.api.remoteservice.contract;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.contract.ShopContractDto;

/**
 * @author huangruodan
 * @version 创建时间：2020/9/17 4:50 下午
 */
@AdvancedFeignClient
public interface RemoteShopContractService {

    /**
     * 保存合同信息
     * @param shopContractDto 合同信息
     * @return
     * @throws BizException
     */
    boolean saveShopContract(ShopContractDto shopContractDto) throws BizException;


    /**
     * 根据商店id查找合同信息
     * @param shopId 商店id
     * @return 合同信息
     * @throws BizException
     */
    ShopContractDto findContractByShopId(Long shopId) throws BizException;
}
