package com.qiho.center.api.util;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Wangpf
 * @description
 * @date 2020/7/22 8:26 下午
 */
public class StringTool {

    private StringTool(){}

    /**
     * list转成String.<br>
     * 分隔符为","
     *
     * @param list the list
     * @return the string by list
     */
    public static String getStringByList(List<String> list) {
        return getStrByCollection(list);
    }

    /**
     * string 转成List<String>.<br>
     * 分隔符为","
     *
     * @param arrayStr the array str
     * @return the string list by str
     */
    public static List<String> getStringListByStr(String arrayStr) {

        if (StringUtils.isNotEmpty(arrayStr)) {
            List<String> list = new ArrayList<>();
            String[] array = arrayStr.split(",");
            for (String s : array) {
                list.add(s);
            }
            return list;
        } else {
            return Collections.emptyList();
        }
    }

    /**
     * collection转成String.<br>
     * 分隔符为","
     *
     * @param collection the collection
     * @return the string by collection
     */
    public static String getStrByCollection(Collection<String> collection) {
        if (!CollectionUtils.isEmpty(collection)) {
            StringBuilder builder = new StringBuilder();
            for (String str : collection) {
                builder.append(str);
                builder.append(",");
            }

            return builder.substring(0, builder.length() - 1);
        }
        return StringUtils.EMPTY;
    }

    /**
     * string 转成Set<String>.<br>
     * 分隔符为","
     *
     * @param arrayStr the array str
     * @return the string Set by str
     */
    public static Set<String> getStrSetByStr(String arrayStr) {

        if (StringUtils.isNotEmpty(arrayStr)) {
            Set<String> set = new HashSet<>();
            String[] array = arrayStr.split(",");
            for (String s : array) {
                set.add(s);
            }
            return set;
        } else {
            return Collections.emptySet();
        }
    }


    /**
     * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>.
     *
     * @param arrayStr the array str
     * @return the long list by str
     */
    public static List<Long> getLongListByStr(String arrayStr) {
        if (StringUtils.isBlank(arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(",");
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    /**
     * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>，此处symbol为",".
     *
     * @param arrayStr the array str
     * @param symbol 字符串分隔符
     * @return the long list by str
     */
    public static List<Long> getLongListByStr(String arrayStr, String symbol) {
        if (StringUtils.isBlank(arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(symbol);
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            if (StringUtils.isEmpty(s) || " ".equals(s)) {
                continue;
            }
            list.add(Long.valueOf(s));
        }
        return list;
    }

    /**
     * Join all values separating them with a comma.
     */
    public static String join(String... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(',').append(value);
        }
        return sb.substring(1);
    }

    /**
     * 根据Long 类型的list 转化为 String
     *
     * @param list
     * @return
     */
    public static String getStringByLongList(List<Long> list) {
        if(list == null || list.isEmpty()){
            return StringUtils.EMPTY;
        }

        List<String> strList = list.stream().map(String::valueOf).collect(Collectors.toList());

        return getStringByList(strList);
    }

    /**
     * 对字符串str进行 中间几位加密
     * eg:
     *     SF1426506769425 加密中间4位 SF142****769425
     *
     * @param str 要加密的字符串
     * @param encryptNum 中间要加密的次数
     * @return
     */
    public static String encrypt(String str, int encryptNum) {

        if(StringUtils.isBlank(str) || encryptNum == 0){
            return str;
        }

        if (str.length() <= encryptNum) {
            return "****";
        }

        int showNum = (str.length() - 4) / 2;

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < showNum; i++) {
            sb.append(str.charAt(i));
        }
        for (int i = 0; i < encryptNum; i++) {
            sb.append("*");
        }
        for (int i =  encryptNum + showNum; i < str.length(); i++) {
            sb.append(str.charAt(i));
        }
        return sb.toString();

    }

}
