package com.qiho.center.api.dto;

/**
 * Created by danke on 2017/6/21.
 * 策略规则类型的dto,主要用于保存策略的json属性
 */
public class StrategyRuleDto extends BaseDto{

    /**
     * 校验
     */
    private String fieldName;
    /**
     * 校验阈值
     */
    private String threshold;
    /**
     * 规则code
     */
    private String ruleName;

    /**
     * 规则是否应用部分商家
     */
    private Boolean partMerchant;

    /**
     * 规则类型code
     */
    private String strategyCode;


    /**
     * 策略商品类型 {@link com.qiho.center.api.enums.order.StrategyItemUserTypeEnum}
     */
    private Integer itemUseType;

    /** 店铺规则适用范围，全部店铺-0，部分店铺生效-1，部分店铺不生效-2 */
    private Integer useType;

    private Long strategyId;

    /**
     * 是否忽略该条规则
     */
    private Boolean isIgnore;

    /**
     * 规则查询的时间范围 如果用不到就是null
     */
    private Integer dayRange;

    /**
     * 产品id
     */
    private String productId;

    /**
     * 从上层 {@link OrderStrategyDto#strategyType} 中取值，为了具体的规则执行的时候，对规则类型进行区分后差异化逻辑处理。
     */
    private Integer strategyType;

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Boolean getIgnore() {
        return isIgnore;
    }

    public void setIgnore(Boolean ignore) {
        isIgnore = ignore;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public Integer getItemUseType() {
        return itemUseType;
    }

    public void setItemUseType(Integer itemUseType) {
        this.itemUseType = itemUseType;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getThreshold() {
        return threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Boolean getPartMerchant() {
        return partMerchant;
    }

    public void setPartMerchant(Boolean partMerchant) {
        this.partMerchant = partMerchant;
    }

    public String getStrategyCode() {
        return strategyCode;
    }

    public void setStrategyCode(String strategyCode) {
        this.strategyCode = strategyCode;
    }

    public String getRuleKey() {
        return getFieldName() + "#" + getStrategyCode() + "#" + getRuleName();
    }

    public Integer getDayRange() {
        return dayRange;
    }

    public void setDayRange(Integer dayRange) {
        this.dayRange = dayRange;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public Integer getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(Integer strategyType) {
        this.strategyType = strategyType;
    }
}
